 ; Ŀ
 ;   Sig - Signal line constructor.                                        
 ;   Copyright 1991, 1998 by Rocket Software                               
 ;   "That lisp stuff will crash the network.  It's probably full of       
 ;    viruses.  Just do your work and stop thinking."                      
 ; 

 ; Ŀ
 ;   Siger - error handler.                                                
 ; 
 (DEFUN SIGER (shk)
  (if (and (/= shk "Function cancelled") (/= shk "")) (print shk))
  (if blip (setvar "blipmode" blip))
  (if clay (setvar "clayer" clay))
  (setq *error* prev)
 (princ))
 ; Ŀ
 ;   Siger end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Sig.                                                       
 ;   Arguments: Xa - line startpoint.                                      
 ;              Xb - line endpoint.                                        
 ;              Len - line segment length.                                 
 ;              Dia - circle diameter.                                     
 ;              Gap - line to circle gap.                                  
 ;   Returns nothing.                                                      
 ; 
 (DEFUN SIG (xa xb len dia gap / totl dd end num xa2 xa xa1 n1 xah)
  (setq totl (+ len dia (* 2 gap)))
  (setq dd (distance xa xb)                         ; total length
        num (fix (/ dd totl))                       ; # of segments
        n1 0                                        ; draw counter
        remn (/ (- (rem dd totl) dia (* 2 gap)) 2)  ; end lengths
        angg (angle xa xb))                         ; setq end
  (if (< remn (+ dia (* 2 gap)))
      (setq num (1- (fix (/ dd totl)))               ; # of segments
            remn (+ (/ totl 2) (/ (- (rem dd totl) dia (* 2 gap)) 2))))
  (cond ((> dd totl)
         (setq xa2 (polar xa angg remn))          ; 1st segment
         (command "line" xa xa2 "")
         (setq xa (polar xa2 angg gap))           ; gap
         (setq xa2 (polar xa angg dia))
         (command "circle" "2p" xa xa2)
         (setq xa (polar xa2 angg gap))
         (while (< n1 num)                        ; draw segments:
                (setq xa1 (polar xa angg len))
                (command "line" xa xa1 "")
                (setq xa1 (polar xa1 angg gap))
                (setq xa2 (polar xa1 angg dia))
                (command "circle" "2p" xa1 xa2)
                (setq xa (polar xa2 angg gap))
                (setq n1 (1+ n1)))
         (command "line" xa xb "")
         (write-line (strcat "Segments drawn: " (itoa (1+ num)))))
        ((> dd (+ (* 2 gap) (* dia 1.25)))
         (command "line" xa (setq xah (polar xa angg 
                                              (/ (- dd dia (* 2 gap)) 2))) "")
         (setq xah (polar xah angg gap))
         (command "circle" "2p" xah (setq xa (polar xah angg dia)))
         (setq xa (polar xa angg gap))
         (command "line" xa xb "")
         (write-line "1 segment squashed in."))
        (T
         (command "line" xa xb "")
         (write-line "Sorry, no room for details.")))
 (princ))
 ; Ŀ
 ;   Sig end.                                                              
 ; 

 ; Ŀ
 ;   Sig.                                                                  
 ; 
 (DEFUN C:SIG (/ xa blip clay)
  (setvar "cmdecho" 0)
  (command "undo" "mark")
  (setq prev *error*)
  (setq *error* siger)
  (if (= xb ())
      (setq xa (getpoint "Start point?\n"))
      (progn
            (setq xa (getpoint "New start or <Return> to continue:\n"))
            (if (= xa ()) (setq xa xb))))
  (setq xb (getpoint xa "And end?\n"))
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq clay (getvar "clayer"))
  (if (tblsearch "layer" "instrline")
      (command "layer" "s" "instrline" "")
      (command "layer" "m" "instrline" "c" "6" "" ""))
  (sig xa xb 11.0 2.0 1.0)
  (siger "")
 (princ))